function EegAnalysis(block)
% Level-2 M file S-function for applying Sobel filtering  
% (image edge detection demonstration).
%   Copyright 1990-2004 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $    
  
  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  block.NumDialogPrms = 5;
  block.DialogPrmsTunable = {'Tunable','Tunable','Tunable','Tunable','Tunable'};
 
  %% Register ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 5;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  blocl.InputPort(1).Overwritable = false; % No in-place operation
  
  block.OutputPort(1).DatatypeID   = 0;
  block.OutputPort(1).Complexity   = 'Real';
  block.OutputPort(1).SamplingMode = 'Sample';
  block.OutputPort(1).Dimensions   = 1;
  
  block.OutputPort(2).DatatypeID   = 0;
  block.OutputPort(2).Complexity   = 'Real';
  block.OutputPort(2).SamplingMode = 'Sample';
  block.OutputPort(2).Dimensions   = 1;
  
  block.OutputPort(3).DatatypeID   = 0;
  block.OutputPort(3).Complexity   = 'Real';
  block.OutputPort(3).SamplingMode = 'Sample';
  block.OutputPort(3).Dimensions   = 1;
  
  block.OutputPort(4).DatatypeID   = 0;
  block.OutputPort(4).Complexity   = 'Real';
  block.OutputPort(4).SamplingMode = 'Sample';
  block.OutputPort(4).Dimensions   = 1;
  
  block.OutputPort(5).DatatypeID   = 0;
  block.OutputPort(5).Complexity   = 'Real';
  block.OutputPort(5).SamplingMode = 'Sample';
  block.OutputPort(5).Dimensions   = 1;
%   block.OutputPort(3).DatatypeID   = 0;
%   block.OutputPort(3).Complexity   = 'Real';
%   block.OutputPort(3).SamplingMode = 'Sample';
%   block.OutputPort(3).Dimensions   = 1;
  
  %% Register block methods (through MATLAB function handles)
  block.RegBlockMethod('Outputs', @Output);
  block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
  block.SetAccelRunOnTLC(true);





function Output(block)
  %pat = size(block.InputPort(1).Data)
  %%dir = block.DialogPrm(1).Data;
 %ratara = size(BancFiltres(block.InputPort(1).Data))
% block.DialogPrm(1).Data
%  block.OutputPort(2).Data
 


%block.OutputPort(1).Data = BancFiltres(block.InputPort(1).Data);
[block.OutputPort(1).Data, block.OutputPort(2).Data, block.OutputPort(3).Data]= tempsreel_CSSD(block.InputPort(1).Data,block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data,block.DialogPrm(5).Data);
block.OutputPort(4).Data =block.DialogPrm(1).Data;
block.OutputPort(5).Data =block.DialogPrm(2).Data;
    %block.OutputPort(2).Data = block.DialogPrm(1).Data
 % block.OutputPort(3).Data = block.DialogPrm(2).Data
%endfunction
%block.DialogPrm(1).Data
%block.DialogPrm(2).Data
% function WriteRTW(block)
%   
%    block.WriteRTWParam('matrix', 'M',    [1 2; 3 4]);
%    block.WriteRTWParam('string', 'Mode', 'Auto');
   

% function moy = Moy(mat)
% moy = mean(mat);
% moy = mean(moy)

function  [y1,y2,y3] = tempsreel_CSSD(signal,freq_lo,freq_hi,SPg,SFg,net)

disp('yaya')
signal = permute(signal,[2 1]);
disp('permutation done')
filtAn = [0.0013 -0.0002 -0.0106 0.0027 0.0347 -0.0192 -0.0367 0.2577 0.5496 0.3404 -0.0433 -0.1013 0.0054 0.0224 -0.0004 -0.0024];

phi0 = filtAn;


%%%%%%%%%%%%%%%%%   -----Ondelettes-------   %%%%%%%%%%%%%%%%%
j = 0;    
h0 = reverse(phi0);                   %  cette ondelette nous donne le signal : eeg32
h1 = reverse(mirror(phi0));           % ... : residu
j = 1;   
H0 = upSample(h0);                  
H1 = upSample(h1);                 
phi10 = waveletLo(phi0,H0);    % eeg16
phi11 = waveletHi(phi0,H1);    % beta = [16-32]Hz
j = 2;
H0 = upSample(H0);
H1 = upSample(H1);
phi20 = waveletLo(phi10,H0);   % eeg8L
phi21 = waveletHi(phi10,H1);   % eeg8H
phi22 = waveletHi(phi11,H1);   % [16-24]Hz
phi23 = waveletLo(phi11,H0);   % [24-32]Hz
j = 3;
H0 = upSample(H0);
H1 = upSample(H1);
phi30 = waveletLo(phi20,H0);   % eeg4
phi31 = waveletHi(phi20,H1);   % theta
phi32 = waveletHi(phi21,H1);   % alpha   = [8-12]Hz
phi33 = waveletLo(phi21,H0);   % sigma   = [12-16]Hz
phi34 = waveletLo(phi22,H0);   % [16-20]Hz
phi35 = waveletHi(phi22,H1);   % [20-24]Hz
phi36 = waveletHi(phi23,H1);   % [24-28]Hz
phi37 = waveletLo(phi23,H0);   % [28-32]Hz
j = 4;
H0 = upSample(H0);
H1 = upSample(H1);
phi40 = waveletLo(phi30,H0);  % eeg2
phi41 = waveletHi(phi30,H1);  % delta 4
phi42 = waveletHi(phi34,H1);   % [16-18]Hz
phi43 = waveletLo(phi34,H0);   % beta1  [18-20]Hz
phi44 = waveletLo(phi35,H0);   % beta3  [22-24]Hz
phi45 = waveletHi(phi35,H1);   % beta2  [20-22]Hz

phi46 = waveletLo(phi32,H0); %alpha [8-10]
phi47 = waveletHi(phi32,H1);%alpha [10-12]

j =5;
H0 = upSample(H0);
H1 = upSample(H1);

phi51 = waveletLo(phi47,H0);%alpha [10-11]
phi52 = waveletHi(phi47,H1);%alpha [11-12]

%%%%%%%%%%%%%%%%

[ech,canaux] = size(signal);

for j=1:canaux
    s = resample(signal(:,j),128,64);
    xx = conv(s,reverse(phi32));
    X(:,j) = redconv(xx,phi32);
    if (j==17)|(j==18)|(j==10)|(j==9)|(j==13)|(j==15)
        eeg32 = redconv(conv(s,reverse(h0)),h0);
        eeg32_var = var(eeg32);
        if eeg32_var == 0
            eeg32_var = 0.00002
        end
        Ik = length(eeg32);
        q=15;
        for i=1:(Ik-q)
            NWPalpha(i,j) = var(X(i:i+q,j))/eeg32_var;
        end
    end
end
y1=median(NWPalpha(:,17)+NWPalpha(:,18)+NWPalpha(:,9)+NWPalpha(:,10)+NWPalpha(:,13)+NWPalpha(:,15));
disp('premire boucle OVER')
if freq_lo == 8
 
    
    if freq_hi == 10
        freq = phi46;
    elseif freq_hi == 12
        freq = phi32;
    end

    
elseif freq_lo == 10
  
    
    if freq_hi == 11
        freq = phi51;
    elseif freq_hi == 12
        freq = phi47;
    end

    
%elseif freq_lo == 12
 %   freq = phi33;


elseif freq_lo == 12
    freq = phi33;


elseif freq_lo == 16
    if freq_hi == 20
        freq = phi34;
    elseif freq_hi == 18
        freq = phi42;
    end
    

elseif freq_lo == 20
    freq = phi35;

end




    for j=1:canaux
    s2 = resample(signal(:,j),128,64);
    xx2 = conv(s,reverse(freq));
    X2(:,j) = redconv(xx2,freq);
    %if (j==17)|(j==18)|(j==10)|(j==9)|(j==13)|(j==15)
        eeg32b = redconv(conv(s2,reverse(h0)),h0);
        eeg32_varb = var(eeg32b);
        if eeg32_varb == 0
            eeg32_varb = 0.00002;
        end
        Ikb = length(eeg32b);
        q=15;
        for i=1:(Ikb-q)
            NWPalpha2(i,j) = var(X2(i:i+q,j))/eeg32_varb;
        end
    end
if (NWPalpha2(:,13) & NWPalpha2(:,15)) ==0
    NWPalpha2(:,13)=0.0001;
end

y2=median((NWPalpha2(:,13)-NWPalpha2(:,15))./(NWPalpha2(:,13)+NWPalpha2(:,15)));
%disp('deuxime over on passe  CSSD')


%pause(5)
%%%%%%%%%CSSD%%%%%%%%%%%
Z=X(:,1:16);
[ech,canaux] = size(Z);
% load SPg;
% load SFg;
% load net;
Xcssdtest =[];
C = Z';
Xcssdtest = SPg*SFg*C;

test=Xcssdtest';
Ptest =[];
for electrode = 1:16
                      Ptest(electrode)=var(test(:,electrode));
%     [Pxxi, Pxxc, F] = PSD(test(:,electrode), 450, 128, 450, 0, 0.95, 'linear');
%     Puissi = mean(Pxxi(find(8 < F & F < 12)));
%     Ptest = cat(1,Ptest,Puissi);
%     Ptesting(:,electrode)=Ptest;
%     Ptest = [];
end
% Py = Ptesting;
Py = Ptest/500;
[Yak, Yak1] = svmfwd(net, Py);
    if Yak1>=-0.06
        yaa=1;
    else
        yaa=-1;
    end
y3=yaa;



function fout = upSample(fin)
o = zeros(1,1);
n = length(fin);
fout = 0;
ftemp = [fin(1);o];
fout = ftemp;
for i=2:n-1
   ftemp = [fin(i);o];
   fout = [fout;ftemp];
end;
fout = [fout;fin(n)];
fout = fout';
   

function y = waveletHi(x,qmf)
y = conv(reverse((mirror(qmf))),x);


function y = waveletLo(x,qmf)
y = conv(qmf,x);


function y = mirror(x)
y = -( (-1).^(1:length(x)) ).*x;


function r = reverse(x)
r = x(length(x):-1:1);

function y = redconv(s,f)
i = round(length(f)/2);
y = s((i):(length(s)-(length(f)-i)));  


function [Y, Y1] = svmfwd(net, X)
% SVMFWD - Forward propagation through Support Vector Machine classifier
% 
%   Y = SVMFWD(NET, X)
%   For a data structure NET, the matrix of vectors X is input into the
%   Support Vector Machine described by NET and the matrix of outputs Y
%   is computed. NET must have non-empty fields NET.sv, NET.svcoeff and
%   NET.bias, these fields are set during training by SVMTRAIN.
%   X must contain one input vector per row. Y is a column vector with
%   one entry for each input vector in X. Y(i) is the SVM output for
%   input vector X(i,:), it is
%     +1, if X(i,:) is classified as belonging to class 1
%     -1, if X(i,:) is classified as belonging to class -1
%   [Y, Y1] = SVMFWD(NET, X) also gives the column vector Y1 containing
%   the SVM output before computing the sign. Y1(i) is equivalent to the
%   distance of point X(i,:) from the separating hyperplane.
%
%   See also
%   SVM, SVMTRAIN, SVMKERNEL
%

% 
% Copyright (c) Anton Schwaighofer (2001)
% $Revision: 1.2 $ $Date: 2002/01/07 19:53:06 $
% mailto:anton.schwaighofer@gmx.net
% 
% This program is released unter the GNU General Public License.
% 

% Check arguments for consistency
errstring = consist(net, 'svm', X);
if ~isempty(errstring);
  error(errstring);
end
[N d] = size(X);
if strcmp(net.kernel, 'linear'),
  if ~isfield(net, 'normalw') | ~all(size(net.normalw)==[1 d]),
    error('Structure NET does not contain a valid field ''normalw''');
  end
else
  if ~isfield(net, 'sv') | ((size(net.sv, 2)~=d) & ~isempty(net.sv)),
    error('Structure NET does not contain a valid field ''sv''');
  end
  nbSV = size(net.sv, 1);
  if nbSV~=size(net.svcoeff, 1),
    error('Structure NET does not contain a valid field ''svcoeff''');
  end
  if ~isfield(net, 'bias') | ~all(size(net.bias)==[1 1]),
    error('Structure NET does not contain a valid field ''bias''');
  end
end

if strcmp(net.kernel, 'linear'),
  Y1 = X*(net.normalw');
else
  chsize = net.chunksize;
  Y1 = zeros(N, 1);
  chunks1 = ceil(N/chsize);
  chunks2 = ceil(nbSV/chsize);
  for ch1 = 1:chunks1,
    ind1 = (1+(ch1-1)*chsize):min(N, ch1*chsize);
    for ch2 = 1:chunks2,
      ind2 = (1+(ch2-1)*chsize):min(nbSV, ch2*chsize);
      K12 = svmkernel(net, X(ind1, :), net.sv(ind2, :));
      Y1(ind1) = Y1(ind1)+K12*net.svcoeff(ind2);
    end
  end
end
Y1 = Y1+net.bias;
Y = sign(Y1);
Y(Y==0) = 1;    

function errstring = consist(model, type, inputs, outputs)
%CONSIST Check that arguments are consistent.
%
%	Description
%
%	ERRSTRING = CONSIST(NET, TYPE, INPUTS) takes a network data structure
%	NET together with a string TYPE containing the correct network type,
%	a matrix INPUTS of input vectors and checks that the data structure
%	is consistent with the other arguments.  An empty string is returned
%	if there is no error, otherwise the string contains the relevant
%	error message.  If the TYPE string is empty, then any type of network
%	is allowed.
%
%	ERRSTRING = CONSIST(NET, TYPE) takes a network data structure NET
%	together with a string TYPE containing the correct  network type, and
%	checks that the two types match.
%
%	ERRSTRING = CONSIST(NET, TYPE, INPUTS, OUTPUTS) also checks that the
%	network has the correct number of outputs, and that the number of
%	patterns in the INPUTS and OUTPUTS is the same.  The fields in NET
%	that are used are
%	  type
%	  nin
%	  nout
%
%	See also
%	MLPFWD
%

%	Copyright (c) Ian T Nabney (1996-9)

% Assume that all is OK as default
errstring = '';

% If type string is not empty
if ~isempty(type)
  % First check that model has type field
  if ~isfield(model, 'type')
    errstring = 'Data structure does not contain type field';
    return
  end
  % Check that model has the correct type
  s = model.type;
  if ~strcmp(s, type)
    errstring = ['Model type ''', s, ''' does not match expected type ''',...
	type, ''''];
    return
  end
end

% If inputs are present, check that they have correct dimension
if nargin > 2
  if ~isfield(model, 'nin')
    errstring = 'Data structure does not contain nin field';
    return
  end

  data_nin = size(inputs, 2);
  if model.nin ~= data_nin
    errstring = ['Dimension of inputs ', num2str(data_nin), ...
	' does not match number of model inputs ', num2str(model.nin)];
    return
  end
end

% If outputs are present, check that they have correct dimension
if nargin > 3
  if ~isfield(model, 'nout')
    errstring = 'Data structure does not conatin nout field';
    return
  end
  data_nout = size(outputs, 2);
  if model.nout ~= data_nout
    errstring = ['Dimension of outputs ', num2str(data_nout), ...
	' does not match number of model outputs ', num2str(model.nout)];
    return
  end

% Also check that number of data points in inputs and outputs is the same
  num_in = size(inputs, 1);
  num_out = size(outputs, 1);
  if num_in ~= num_out
    errstring = ['Number of input patterns ', num2str(num_in), ...
	' does not match number of output patterns ', num2str(num_out)];
    return
  end
end
function K = svmkernel(net, X1, X2)
% SVMKERNEL - Compute Support Vector Machine kernel function
% 
%   K = SVMKERNEL(NET, X1, X2)
%   The Support Vector Machine structure NET must contain 2 field
%   NET.kernel and NET.kernelpar, selecting the kernel function and its
%   parameters. X1 and X2 contain one example per row. If X1 is of size
%   [M, NET.nin] and X2 is of size [N, NET.nin], K will be a matrix
%   [M, N]. K(i,j) is the result of the kernelfunction for inputs X1(i,:)
%   and X2(j,:).
%   Currently the only valid kernel functions are
%   NET.kernel = 'linear' 
%       inner product
%   NET.kernel = 'poly'
%       (1+inner product)^NET.kernelpar(1)
%   NET.kernel = 'rbf'
%       radial basis function, common length scale for all inputs is
%       NET.kernelpar(1), scaled with the number of inputs NET.nin
%       K = exp(-sum((X1i-X2i)^2)/(NET.kernelpar(1)*NET.nin))
%   NET.kernel = 'rbffull'
%       radial basis function, different length scale for each input.
%       If NET.kernelpar is a vector of length NET.nin
%       K = exp(-sum((X1i-X2i)^2*NET.kernelpar(i))/NET.nin)
%       If NET.kernelpar is a vector of length NET.nin+1
%       K = exp(NET.kernelpar(end)-sum((X1i-X2i)^2*NET.kernelpar(i))/NET.nin)
%       If NET.kernelpar is a matrix of size [NET.nin, NET.nin]
%       K = exp(-(X1-X2)*NET.kernelpar*(X1-X2)'/NET.nin)
%
%   See also
%   SVM, SVMTRAIN, SVMFWD
%

% 
% Copyright (c) Anton Schwaighofer (2001)
% $Revision: 1.3 $ $Date: 2001/06/18 15:21:55 $
% mailto:anton.schwaighofer@gmx.net
% 
% This program is released unter the GNU General Public License.
% 

errstring = consist(net, 'svm', X1);
if ~isempty(errstring);
  error(errstring);
end
errstring = consist(net, 'svm', X2);
if ~isempty(errstring);
  error(errstring);
end
[N1, d] = size(X1);
[N2, d] = size(X2);

switch net.kernel
  case 'linear'
    K = X1*X2';
  case 'poly'
    K = (1+X1*X2').^net.kernelpar(1);
  case 'rbf'
    dist2 = repmat(sum((X1.^2)', 1), [N2 1])' + ...
            repmat(sum((X2.^2)',1), [N1 1]) - ...
            2*X1*(X2');
    K = exp(-dist2/(net.nin*net.kernelpar(1)));
  case 'rbffull'
    bias = 0;
    if any(all(repmat(size(net.kernelpar), [4 1]) == ...
               [d 1; 1 d; d+1 1; 1 d+1], 2), 1),
      weights = diag(net.kernelpar(1:d));
      if length(net.kernelpar)>d,
        bias = net.kernelpar(end);
      end
    elseif all(size(net.kernelpar)==[d d]),
      weights = net.kernelpar;
    else
      error('Size of NET.kernelpar does not match the chosen kernel ''rbffull''');
    end
    dist2 = (X1.^2)*weights*ones([d N2]) + ...
            ones([N1 d])*weights*(X2.^2)' - ...
            2*X1*weights*(X2');
    K = exp(bias-dist2/net.nin);
  otherwise
    error('Unknown kernel function');
end
K = double(K);
% Convert to full matrix if inputs are sparse


